package org.msh.tb.reports2.me;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.international.Messages;
import org.msh.tb.adminunits.AdminUnitSelection;
import org.msh.tb.indicators.core.IndicatorFilters;
import org.msh.tb.tbunits.TBUnitSelection;

import java.util.List;

/**
 * Controller component used by the UI to generate a standard Monitoring and Evaluation report
 *
 * Created by rmemoria on 7/12/16.
 */
@Name("meReportController")
public class MeReportController {

    @In
    MeReportService meReportService;

    @In(create = true)
    IndicatorFilters indicatorFilters;


    /**
     * The report ID, defined in the enum constants
     */
    private MeReportId id;


    /**
     * The select TB unit, if available
     */
    private Integer unitId;

    /**
     * The report content
     */
    private List<TableData> data;

    /**
     * Force updating of the report
     */
    public void update() {
        data = null;
    }

    /**
     * Generate the report according to the Id property
     * @return
     */
    public void execute() {
        if (data != null) {
            return;
        }

        if (id == null) {
            throw new RuntimeException("No report selected");
        }

        Integer selUnitId = null;
        Integer adminUnitId = null;

        if (unitId != null) {
            selUnitId = unitId;
        } else {
            TBUnitSelection sel = indicatorFilters.getTbunitselection();
            if (sel.getSelected() != null) {
                selUnitId = sel.getSelected().getId();
            } else {
                adminUnitId = sel.getAdminUnitId();
            }
        }

        // generate the report
        data = meReportService.execute(id, selUnitId, adminUnitId,
                indicatorFilters.getQuarter(),
                indicatorFilters.getYear(),
                indicatorFilters.getClassification());
    }


    public List<TableData> getData() {
        if (data == null) {
            execute();
        }
        return data;
    }

    public MeReportId getId() {
        return id;
    }

    public void setId(MeReportId id) {
        this.id = id;
    }


    public Integer getUnitId() {
        return unitId;
    }

    public void setUnitId(Integer unitId) {
        this.unitId = unitId;
    }

    /**
     * Return the list of report IDs
     * @return
     */
    public MeReportId[] getReportIds() {
        return MeReportId.values();
    }

    public String getReportTitle(MeReportId id) {
        String key = MeReportId.class.getSimpleName() + "." + id.toString();
        return Messages.instance().get(key);
    }
}
